
<?php include 'includes/head.php' ?>
    <body class="sb-nav-fixed">
    <style>
        .ui-autocomplete {
            z-index: 1051 !important; /* Ensure it is above Bootstrap modal (which is 1050) */
            position: absolute; /* Required for correct positioning */
            background: white; /* Ensure visibility */
            border: 1px solid #ccc;
            max-height: 200px;
            overflow-y: auto;
        }
  </style>
        <?php include 'includes/topnav.php' ?>
        <div id="layoutSidenav">
            <?php include 'includes/sidenav.php' ?>
            <div id="layoutSidenav_content">
                <main>
                    <div class="row mx-2">
                        <div class="col-12 grid-margin stretch-card">
                            <div class="card mt-2">
                                <div class="row mt-1">
                                    <div class="col-lg-12 col-md-12">
                                        <div class="card-body">
                                            <h5 class="card-title">Student Subscription</h5>
                                        </div>
                                        <div class="col-lg-4 mx-2 mb-2">
                                            <div class="card">
                                                <div class="card-body">
                                                    <h6 class="">Subscription Id : <span id="userid"><?= $_SESSION['studentid']?></span></h6>
                                                    <h6 class="">Subscribed By : <span class=""><?= $_SESSION['sfname']?></span></h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="container">
                                            <div class="col-lg-12 mb-2">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <div class="row d-flex justify-content-center">
                                                            <div class="col-lg-4">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="studentid" class="form-label mb-2">Student Id or First Name</label>
                                                                    <input class="form-control form-control-sm" id="studentid" type="text" placeholder="ID" aria-label=".form-control-sm example">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row d-flex justify-content-center">
                                                            <div class="col-lg-1">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="studentsid" class="form-label mb-2">ID</label>
                                                                    <input class="form-control form-control-sm" id="studentsid" type="text" placeholder="Id" aria-label=".form-control-sm example" disabled>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-3">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="studentname" class="form-label mb-2">Student Name</label>
                                                                    <input class="form-control form-control-sm" id="studentname" type="text" placeholder="Student Name" aria-label=".form-control-sm example" disabled>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="studentgrade" class="form-label mb-2">Student Grade</label>
                                                                    <input class="form-control form-control-sm" id="studentgrade" type="text" placeholder="Grade" aria-label=".form-control-sm example" disabled>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row d-flex justify-content-center">
                                                            <div class="col-lg-4">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="videoname" class="form-label mb-2">Video Name</label>
                                                                    <input class="form-control form-control-sm" id="videoname" type="text" placeholder="Video Name" aria-label=".form-control-sm example">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row d-flex justify-content-center">
                                                            <div class="col-lg-1">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="videoid" class="form-label mb-2">ID</label>
                                                                    <input class="form-control form-control-sm" id="videoid" type="text" placeholder="Id" aria-label=".form-control-sm example" disabled>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-3">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="videomaintitle" class="form-label mb-2">Main Title</label>
                                                                    <input class="form-control form-control-sm" id="videomaintitle" type="text" placeholder="Main Title" aria-label=".form-control-sm example" disabled>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4">
                                                                <div class="input-group-sm mb-2">
                                                                    <label for="videosubtitle" class="form-label mb-2">Sub Title</label>
                                                                    <input class="form-control form-control-sm" id="videosubtitle" type="text" placeholder="Sub Title" aria-label=".form-control-sm example" disabled>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="d-flex justify-content-center">
                                                                    <button type="button" id="subscribeBtn" class="btn btn-sm btn-success mb-3 mx-2">
                                                                        <i class="fa-solid fa-cart-shopping mx-2"></i>Subscribe
                                                                    </button>
                                                                    <button type="button" class="btn btn-sm btn-secondary mb-3">
                                                                        <i class="fa-solid fa-delete-left mx-2"></i>Clear
                                                                    </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="successMessage" class="alert alert-success text-center" style="display: none;"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </main>
                <?php include 'includes/footer.php' ?>
            </div>
        </div>
        <?php include 'includes/js.php' ?>

        <Script>
            $(document).ready(function () {

                let selectedMainTitleId = null; // Store the selected title ID
                let selectedTitleId = null; // Store the selected title ID

                $("#studentid").autocomplete({
                    source: function (request, response) {
                        $.ajax({
                            url: "controller/getstdetails.php",  // Correct path to your PHP file
                            dataType: "json",
                            data: { term: request.term },  // Send the search term to PHP
                            success: function (data) {
                                console.log("Received Data:", data);  // Debugging output

                                if (Array.isArray(data) && data.length > 0) {
                                    response(
                                        data.map(item => ({
                                            label: item.label,  // Display in autocomplete dropdown
                                            value: item.value,  // Set in input field
                                            id: item.id,         // Store the ID
                                            slname: item.slname,
                                            sgrade: item.sgrade
                                        }))
                                    );
                                } else {
                                    console.log("No suggestions found.");
                                    response([]);  // No results
                                }
                            },
                            error: function (xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,  // Minimum length of the search term before triggering autocomplete
                    appendTo: "body",  // Append the autocomplete dropdown to the body
                    select: function (event, ui) {
                        console.log("Selected Student:", ui.item.value, "ID:", ui.item.id);
                        $("#studentid").val(ui.item.value);  // Ensure input field updates
                        $("#studentsid").val(ui.item.id);  // Ensure input field updates
                        selectedStudentId = ui.item.id;  //  Store the selected student ID
                        console.log("Stored ID:", selectedStudentId);  // Debugging
                        $("#studentname").val(ui.item.value + " " + ui.item.slname);
                        $("#studentgrade").val(ui.item.sgrade);
                        return false;  // Prevent default behavior
                    }
                });

                $("#videoname").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "controller/getvideodetails.php",
                            dataType: "json",
                            data: { term: request.term },
                            success: function(data) {
                                console.log("Received Data:", data); // Debugging output
                                
                                const studentGrade = parseInt($("#studentgrade").val(), 10) || 0; // Get student grade

                                // Filter data to show only matching grades
                                const filteredData = data.filter(item => item.videograde == studentGrade);

                                if (filteredData.length > 0) {
                                    response(filteredData.map(item => ({
                                        label: item.label, // Display in autocomplete list
                                        value: item.value, // Set in input field
                                        id: item.id,
                                        videograde: item.videograde, // Store for later use
                                        maintitle: item.maintitle,
                                        subtitle: item.subtitle
                                    })));
                                } else {
                                    console.log("No matching grade suggestions found.");
                                    response([]); // No results if no grade matches
                                }
                            },
                            error: function(xhr, status, error) {
                                console.log("AJAX Error:", error);
                            }
                        });
                    },
                    minLength: 1,
                    appendTo: "body",
                    select: function(event, ui) {
                        console.log("Selected:", ui.item.value, "ID:", ui.item.id);
                        $("#videoname").val(ui.item.value); // Set the selected title
                        $("#videomaintitle").val(ui.item.maintitle); // Set the selected title
                        $("#videosubtitle").val(ui.item.subtitle); // Set the selected title
                        $("#videoid").val(ui.item.id); // Set the selected title

                        // Store the selected title ID for further use
                        selectedTitleId = ui.item.id;
                        console.log("Stored Title ID:", selectedTitleId);

                        return false;  // Prevent default behavior
                    }
                });

                $("#subscribeBtn").click(function () {
                    // Collect data from the form fields (including disabled ones)
                    const userid = $("#userid").text();
                    const jrole = <?php echo json_encode($_SESSION['jRole']); ?>;
                    const videoId = $("#videoid").val();
                    const studentsid = $("#studentsid").val();

                    // Check if required fields are filled
                    if (!userid || !jrole || !videoId || !studentsid) {
                        Swal.fire("Error", "Please select a video and make sure all fields are filled!", "error");
                        return;
                    }

                    // Confirm before subscribing
                    Swal.fire({
                        title: "Confirm Subscription",
                        text: "Are you sure you want to subscribe?",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonText: "Yes, Subscribe!",
                        cancelButtonText: "Cancel"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // AJAX request to send data to the server
                            $.ajax({
                                url: "controller/addsubscription.php", // Your PHP script to handle subscription
                                type: "POST",
                                dataType: "json", // Expect JSON response
                                data: {
                                    userid: userid,
                                    jrole: jrole,
                                    videoid: videoId,
                                    studentid: studentsid
                                },
                                success: function (response) {
                                    console.log("Response:", response);
                                    if (response.success) {
                                        Swal.fire({
                                            title: "Success!",
                                            text: "Subscription successful!",
                                            icon: "success",
                                            timer: 2000, // Auto-close after 2 seconds
                                            showConfirmButton: false
                                        });

                                        // Clear input fields after success
                                        $("#videoname").val("");
                                        $("#videomaintitle").val("");
                                        $("#videosubtitle").val("");
                                        $("#videoid").val("");
                                        // $("#studentname").val("");
                                        // $("#studentsid").val("");
                                        // $("#studentgrade").val("");
                                        
                                    } else {
                                        Swal.fire("Error", response.message, "error");
                                    }
                                },
                                error: function (xhr, status, error) {
                                    console.log("AJAX Error:", error);
                                    Swal.fire("Error", "Something went wrong. Please try again.", "error");
                                }
                            });
                        }
                    });
                });


            });



        </Script>

    </body>
</html>
